/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.unique;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.utility.WaitAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.vfx.combat.FlashAtkImgEffect;

public class SwordBoomerangAction
extends AbstractGameAction {
    private DamageInfo info;
    private static final float DURATION = 0.2f;
    private static final float POST_ATTACK_WAIT_DUR = 0.1f;
    private int numTimes;

    public SwordBoomerangAction(AbstractCreature target, DamageInfo info, int numTimes) {
        this.info = info;
        this.target = target;
        this.actionType = AbstractGameAction.ActionType.DAMAGE;
        this.attackEffect = AbstractGameAction.AttackEffect.SLASH_HORIZONTAL;
        this.duration = 0.2f;
        this.numTimes = numTimes;
    }

    @Override
    public void update() {
        if (this.target == null) {
            this.tickDuration();
            this.isDone = true;
            return;
        }
        if (this.duration == 0.2f && this.target.currentHealth > 0) {
            this.target.damageFlash = true;
            this.target.damageFlashFrames = 4;
            AbstractDungeon.effectList.add(new FlashAtkImgEffect(this.target.hb.cX, this.target.hb.cY, this.attackEffect));
        }
        this.tickDuration();
        if (this.isDone && this.target.currentHealth > 0) {
            this.info.applyPowers(this.info.owner, this.target);
            this.target.damage(this.info);
            if (AbstractDungeon.getCurrRoom().monsters.areMonstersBasicallyDead()) {
                AbstractDungeon.actionManager.clearPostCombatActions();
            }
            if (this.numTimes > 1 && !AbstractDungeon.getMonsters().areMonstersBasicallyDead()) {
                --this.numTimes;
                AbstractDungeon.actionManager.addToTop(new SwordBoomerangAction(AbstractDungeon.getMonsters().getRandomMonster(true), this.info, this.numTimes));
            }
            AbstractDungeon.actionManager.addToTop(new WaitAction(0.1f));
        }
    }
}

